/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimensionbuilder.items;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsdim.dimension.data.ClientDimensionData;
import mcjty.rftoolsdim.dimension.data.DimensionData;
import mcjty.rftoolsdim.dimension.data.DimensionSettings;
import mcjty.rftoolsdim.dimension.data.PersistantDimensionManager;
import mcjty.rftoolsdim.dimension.descriptor.CompiledDescriptor;
import mcjty.rftoolsdim.dimension.descriptor.CompiledFeature;
import mcjty.rftoolsdim.dimension.descriptor.DescriptorError;
import mcjty.rftoolsdim.dimension.descriptor.DimensionDescriptor;
import mcjty.rftoolsdim.dimension.terraintypes.RFToolsChunkGenerator;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraftforge.server.ServerLifecycleHooks;

public class RealizedDimensionTab
extends Item {
    public RealizedDimensionTab() {
        super(new Item.Properties().m_41487_(1));
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_ && player.m_6144_()) {
            CompoundTag tagCompound = stack.m_41783_();
            Logging.message((Player)player, (String)tagCompound.m_128461_("descriptor"));
            if (tagCompound.m_128441_("dimension")) {
                String dimension = tagCompound.m_128461_("dimension");
                DimensionData data = PersistantDimensionManager.get(world).getData(new ResourceLocation(dimension));
                if (data != null) {
                    player.m_5661_((Component)ComponentFactory.literal((String)(ChatFormatting.BLUE + "Energy: " + ChatFormatting.WHITE + data.getEnergy())), false);
                    DimensionDescriptor descriptor = data.getDescriptor();
                    descriptor.dump(player);
                    player.m_5661_((Component)ComponentFactory.literal((String)"-----------------------------"), false);
                    DimensionDescriptor randomized = data.getRandomizedDescriptor();
                    randomized.dump(player);
                }
                ResourceKey id = LevelTools.getId((String)dimension);
                ServerLevel serverWorld = ServerLifecycleHooks.getCurrentServer().m_129880_(id);
                ChunkGenerator generator = serverWorld.m_7726_().m_8481_();
                if (generator instanceof RFToolsChunkGenerator) {
                    DimensionSettings settings = ((RFToolsChunkGenerator)generator).getDimensionSettings();
                    player.m_5661_((Component)ComponentFactory.literal((String)(ChatFormatting.BLUE + "Seed: " + ChatFormatting.WHITE + settings.getSeed())), false);
                }
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> list, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, list, flagIn);
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound != null) {
            ResourceLocation dimension;
            ResourceLocation resourceLocation = dimension = tagCompound.m_128441_("dimension") ? new ResourceLocation(tagCompound.m_128461_("dimension")) : null;
            if (dimension != null) {
                list.add((Component)ComponentFactory.literal((String)("Name: " + dimension.m_135815_())).m_130940_(ChatFormatting.BLUE));
            } else if (tagCompound.m_128441_("name")) {
                String name = tagCompound.m_128461_("name");
                list.add((Component)ComponentFactory.literal((String)("Name: " + name)).m_130940_(ChatFormatting.BLUE));
            }
            if (SafeClientTools.isSneaking()) {
                String descriptionString = tagCompound.m_128461_("descriptor");
                String randomizedString = tagCompound.m_128461_("randomized");
                this.constructDescriptionHelp(list, descriptionString, randomizedString);
            } else {
                list.add((Component)ComponentFactory.literal((String)(ChatFormatting.GREEN + "    <Press Shift>")));
            }
            int ticksLeft = tagCompound.m_128451_("ticksLeft");
            if (ticksLeft == 0) {
                long power = ClientDimensionData.get().getPower(dimension);
                long max = ClientDimensionData.get().getMaxPower(dimension);
                list.add((Component)ComponentFactory.literal((String)"Dimension ready!").m_130940_(ChatFormatting.BLUE));
                int maintainCost = tagCompound.m_128451_("rfMaintainCost");
                list.add((Component)ComponentFactory.literal((String)(ChatFormatting.YELLOW + "    Maintenance cost: " + maintainCost + " RF/tick")));
                list.add((Component)ComponentFactory.literal((String)(ChatFormatting.YELLOW + "    Current power: " + power + " (" + max + ")")));
            } else {
                int createCost = tagCompound.m_128451_("rfCreateCost");
                int maintainCost = tagCompound.m_128451_("rfMaintainCost");
                int tickCost = tagCompound.m_128451_("tickCost");
                int percentage = 0;
                if (tickCost != 0) {
                    percentage = (tickCost - ticksLeft) * 100 / tickCost;
                }
                list.add((Component)ComponentFactory.literal((String)(ChatFormatting.BLUE + "Dimension progress: " + percentage + "%")));
                list.add((Component)ComponentFactory.literal((String)(ChatFormatting.YELLOW + "    Creation cost: " + createCost + " RF/tick")));
                list.add((Component)ComponentFactory.literal((String)(ChatFormatting.YELLOW + "    Maintenance cost: " + maintainCost + " RF/tick")));
                list.add((Component)ComponentFactory.literal((String)(ChatFormatting.YELLOW + "    Tick cost: " + tickCost + " ticks")));
            }
        }
    }

    private void constructDescriptionHelp(List<Component> list, String descriptionString, String randomizedString) {
        DimensionDescriptor descriptor = new DimensionDescriptor();
        descriptor.read(descriptionString);
        DimensionDescriptor randomizedDescriptor = new DimensionDescriptor();
        if (!randomizedString.isEmpty()) {
            randomizedDescriptor.read(randomizedString);
        }
        CompiledDescriptor compiledDescriptor = new CompiledDescriptor();
        try {
            compiledDescriptor.compile(descriptor, randomizedDescriptor);
            if (compiledDescriptor.getTerrainType() != null) {
                list.add((Component)ComponentFactory.literal((String)(ChatFormatting.GREEN + "    Terrain: " + ChatFormatting.WHITE + compiledDescriptor.getTerrainType().getName())));
            }
            if (compiledDescriptor.getBiomeControllerType() != null) {
                list.add((Component)ComponentFactory.literal((String)(ChatFormatting.GREEN + "    Biome Controller: " + ChatFormatting.WHITE + compiledDescriptor.getBiomeControllerType().getName())));
            }
            if (compiledDescriptor.getTimeType() != null) {
                list.add((Component)ComponentFactory.literal((String)(ChatFormatting.GREEN + "    Time: " + ChatFormatting.WHITE + compiledDescriptor.getTimeType().getName())));
            }
            for (CompiledFeature feature : compiledDescriptor.getFeatures()) {
                list.add((Component)ComponentFactory.literal((String)(ChatFormatting.GREEN + "    Feature: " + ChatFormatting.WHITE + feature.getFeatureType().getName())));
            }
        }
        catch (DescriptorError error) {
            list.add((Component)ComponentFactory.literal((String)(ChatFormatting.RED + "Parse error: " + error.getMessage())));
        }
    }
}

